/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.DeviceView.DefaultStatus;
import ibm.nways.jdm8260.DeviceView.GrayableLike;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.StatusRefLike;
import ibm.nways.jdm8260.DeviceView.TrunkLike;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;

public class Trunk
implements TrunkLike,
StatusRefLike,
GrayableLike {
    protected int slot;
    protected int trunk;
    protected int connectorType;
    protected int trunkType;
    protected int network;
    protected Status statusRef;
    protected GraphicContainer container;
    protected GraphicImage trunkGraphicImage;
    protected String cookieID;
    protected GenModel trunkModel;
    protected String destinationPanel;
    protected HubInfoLike hub;
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8260.DeviceView.GraphicResources";
    private static final String SER_PATH = "ibm.nways.jdm8260.WCDefault";
    private static final int COOKIE_FLAGS = 20;
    public static final int RJ45 = 0;
    public static final int FC = 1;

    public void dispose() {
        this.statusRef = null;
        this.trunkGraphicImage = null;
        this.hub = null;
        this.trunkModel = null;
        this.container = null;
    }

    public void setStatusRef(Status status) {
        this.statusRef = status;
    }

    public Status getStatusRef() {
        return this.statusRef;
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, String string, int n, int n2, int n3, int n4, int n5, int n6, GraphicContainer graphicContainer, String string2, GenModel genModel) {
        this.hub = hubInfoLike;
        this.cookieID = string;
        this.slot = n;
        this.trunk = n2;
        this.connectorType = n3;
        this.trunkType = n4;
        this.container = graphicContainer;
        this.network = this.checkNetwork(n6, n5);
        this.trunkModel = genModel;
        this.destinationPanel = string2;
    }

    public void gray() {
        String string = "gray";
        if (this.trunkGraphicImage.getStatus() != DefaultStatus.getDefaultStatus()) {
            this.trunkGraphicImage.setVisible(false);
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Trunk grayed: " + this);
            }
        }
    }

    public void ungray() {
        String string = "ungray";
        if (this.statusRef != null) {
            this.trunkGraphicImage.setVisible(true);
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Trunk highlighted: " + this);
            }
        }
    }

    public void draw() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.TrunkSlotIndex", new Integer(this.slot));
        modelInfo.add("Index.TrunkIndex", new Integer(this.trunk));
        WidgetCookie widgetCookie = new WidgetCookie(this.cookieID, BUNDLE_NAME, modelInfo, SER_PATH, this.trunkModel, this.hub.getBrowser(), 20, this.destinationPanel);
        this.trunkGraphicImage = widgetCookie.GetImage();
        if (this.trunkModel != null) {
            this.hub.askStatus(this.trunkModel, widgetCookie.GetImage(), modelInfo, this);
        }
        widgetCookie.GetImage().setStatus(DefaultStatus.getDefaultStatus());
        this.container.add((GraphicContainer)widgetCookie);
    }

    private int checkNetwork(int n, int n2) {
        int n3 = n == 4 ? n2 : n;
        this.hub.getNetworksWindow().addObjectToNetwork(n3, this);
        return n3;
    }

    public String toString() {
        return "Slot -> " + this.slot + " trunkNumber -> " + this.trunk;
    }
}

